/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.potion.effect;

import com.lothrazar.cyclic.potion.CyclicMobEffect;
import com.lothrazar.cyclic.util.PlayerUtil;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;

public class FlightMayflyEffect
extends CyclicMobEffect {
    public FlightMayflyEffect(MobEffectCategory typeIn, int liquidColorIn) {
        super(typeIn, liquidColorIn);
    }

    @Override
    public void onPotionAdded(PotionEvent.PotionAddedEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_150110_().f_35936_) {
                PlayerUtil.setMayFlyFromServer(event.getEntityLiving(), true);
            }
        }
    }

    @Override
    public void isPotionApplicable(PotionEvent.PotionApplicableEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_7500_()) {
                event.setResult(Event.Result.DENY);
            }
        } else {
            event.setResult(Event.Result.DENY);
        }
    }

    @Override
    public void onPotionRemove(PotionEvent.PotionRemoveEvent event) {
        PlayerUtil.setMayFlyFromServer(event.getEntityLiving(), false);
    }

    @Override
    public void onPotionExpiry(PotionEvent.PotionExpiryEvent event) {
        PlayerUtil.setMayFlyFromServer(event.getEntityLiving(), false);
    }
}

